/***************************************************************************
 *   SymSolon - a free astrology software                                  *
 *   Copyright (C) 2007 by Bela MIHALIK                                    *
 *   bela.mihalik@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "aspectmatrix.h"


AspectMatrixClass::AspectMatrixClass()
{
    memset( matrix, 0, sizeof(matrix) );
}


AspectMatrixClass::~AspectMatrixClass()
{
}


// prototype defines default solsys2 to NULL so can be omitted
void
AspectMatrixClass::calculate( SolarSystemClass *solsys1, SolarSystemClass *solsys2, float orbit_divider )
{
    int                i=0, j=0, k=0, n=0;
    PlanetClass        **pv1=NULL, **pv2=NULL;
    double            diff=0, orbit=0, orbitMirror=0, result=0;
    
    if (solsys1 == NULL) return;
    if (solsys2 == NULL)
    {
        pv1 = pv2 = solsys1->planetVector;
    }
    else // synastry or transit analysis   // or horoscope if done right
    {
        pv1 = solsys1->planetVector;
        pv2 = solsys2->planetVector;
    }
    
    n = solsys1->numberOfPlanets;
    
    // Initialize arrays in class object to 0
    memset( matrix, 0, sizeof(matrix) );
    memset( powerMatrix, 0, sizeof(powerMatrix) );
    
    for (i=0; i<n; i++)
    {
        for (j=0; j<n; j++)
        {
            // the two nodes can specify the occurance of an eclipse - lunar or solar
            // when the moon is in alignment with a node and the sun
            if ( pv1==pv2 && i==j ) continue;
            if ( (pv1[i]->index == PLANET_SOUTH_NODE || pv2[j]->index == PLANET_NORTH_NODE) ||
                 (pv1[i]->index == PLANET_NORTH_NODE || pv2[j]->index == PLANET_SOUTH_NODE) )
            {
                if (pv1[i]->index != PLANET_MOON && pv2[j]->index != PLANET_MOON)
                        continue;
            }
            if ( (pv1[i]->index == PLANET_SOUTH_NODE && pv2[j]->index == PLANET_NORTH_NODE) ||
                 (pv1[i]->index == PLANET_NORTH_NODE && pv2[j]->index == PLANET_SOUTH_NODE) )
            {
                continue;
            }
            if ( pv1[i]->Long >= pv2[j]->Long ) diff = pv1[i]->Long - pv2[j]->Long;
                                           else diff = (pv1[i]->Long+360) - pv2[j]->Long;
            if (diff > 180) diff = 360 - diff;     // ANGLE DIFF convert to +/- 180 deg so absolutes work
                        
            for (k=0; k<ASPECT_MAX; k++)
            {
                if (SolonConfig->aspectOrbitAsLimit)
                {
                    orbit =    (Symbol->planetInfo[ pv1[i]->index ].orbit/2.) +
                            (Symbol->planetInfo[ pv2[j]->index ].orbit/2.);
                    if (orbit > Symbol->aspectInfo[k].orbit)
                            orbit = Symbol->aspectInfo[k].orbit;
                }
                else
                {
                    orbit = (Symbol->aspectInfo[k].orbit) +
                        (Symbol->planetInfo[ pv1[i]->index ].orbit/2.) +
                        (Symbol->planetInfo[ pv2[j]->index ].orbit/2.);
                }

                orbit = orbit /orbit_divider;  // thin aspect calcs

                if ( !Symbol->aspectInfo[k].enabled ) continue;  // what ASPECT?

// If doing MOON and NODES COMPUTE STRENGTH BASED ON  +/- 1.3 deg of LAT
                if ( (pv1[i]->index == PLANET_SOUTH_NODE || pv2[j]->index == PLANET_NORTH_NODE) ||
                     (pv1[i]->index == PLANET_NORTH_NODE || pv2[j]->index == PLANET_SOUTH_NODE) )
                {
                    if (pv1[i]->index != PLANET_MOON && pv2[j]->index != PLANET_MOON) continue;

                    if ((Symbol->aspectInfo[k].angle != 0) && (Symbol->aspectInfo[k].angle != 180)) continue;
                    result = ABSOLUTE( Symbol->aspectInfo[k].angle - diff );
                    if ( result <= orbit )
                    {
                        // Update Matrix with ASPECT and POWER / STRENGTH
                        matrix[ pv1[i]->index ][ pv2[j]->index] = (AspectIndexType)k;
                        powerMatrix[ pv1[i]->index ][ pv2[j]->index] =
                                                    100-(int)((100*result)/orbit);
                    }

                }
                else if ( k == ASPECT_MIRROR )               // if MIRROR calculate STRENGTH differently
                {
                    orbitMirror = orbit;
                    result = ABSOLUTE( pv1[i]->Long - (360-pv2[j]->Long) ) - orbitMirror;
                    if ( result <= 0 )
                    {
                        // Update Matrix with ASPECT and POWER / STRENGTH
                        matrix[ pv1[i]->index ][ pv2[j]->index] = (AspectIndexType)k;
                        powerMatrix[ pv1[i]->index ][ pv2[j]->index] =
                                                (int)(-(100*result)/orbitMirror);
                    }
                }
                else                                    // if any other ASPECT calculate STRENGTH
                {
                    result = ABSOLUTE( Symbol->aspectInfo[k].angle - diff );                    
                    if ( result <= orbit )
                    {
                        // Update Matrix with ASPECT and POWER / STRENGTH
                        matrix[ pv1[i]->index ][ pv2[j]->index] = (AspectIndexType)k;
                        powerMatrix[ pv1[i]->index ][ pv2[j]->index] =
                                                    100-(int)((100*result)/orbit);
                    }
                }
            }
        }
    }
}

